from django.urls import path
from . import views
from .views import welcome_view 
from .views import travel_bill_report
from .views import delete_record
from .views import update_record
from django.contrib.auth import views as auth_views
from django.conf import settings
from django.conf.urls.static import static



urlpatterns = [
    path("", views.login_view, name="login"),  
    path("kds/", views.kds, name="kds"),
    path("agent/", views.agent, name="agent"),
    # path("", welcome_view, name="welcome"),
    path('bill_generate/', views.bill_generate, name='bill_generate'),
    path('travel_bill_submission/', views.travel_bill_submission, name='travel_bill_submission'),
    path("welcome/", views.welcome_view, name="welcome"),
    path("travel-bill/", views.travel_bill_submission, name="travel_bill_submission"),
    path('reports/', travel_bill_report, name='travel_bill_report'),
    path('delete-record/<int:record_id>/', delete_record, name='delete_record'),
    path('update-record/<int:record_id>/', update_record, name='update_record'),
    path("logout/", auth_views.LogoutView.as_view(next_page="login"), name="logout"),
    path('travel_bill_report/', travel_bill_report, name='travel_bill_report'),
    
] + static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
